package gov.va.med.mhv.admin.validator;

import java.util.LinkedHashMap;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.admin.dto.CalendarCategoryDTO;
import gov.va.med.mhv.admin.dto.CategoryDTO;
import gov.va.med.mhv.admin.service.calendar.CalendarEventService;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;

@Component
public class CalendarCategoryValidator extends Validator {
	
	@Autowired
	private CalendarEventService calendarEventService;


	public ResponseUtil<CalendarCategoryDTO> fieldValidations(CalendarCategoryDTO calendarCategoryDTO) throws MHVException {
		
		ResponseUtil<CalendarCategoryDTO> response = new ResponseUtil<CalendarCategoryDTO>();
		LinkedHashMap<String, String> validationErrors = new LinkedHashMap<String, String>();
		validateCalendarCategoryName(calendarCategoryDTO,validationErrors);
		response.setValidationErrors(validationErrors);
		return response;
	}

	private void validateCalendarCategoryName(CalendarCategoryDTO calendarCategoryDTO,
			LinkedHashMap<String, String> validationErrors) throws MHVException {
		
		List<CategoryDTO> categoryDtos;
		try {
			categoryDtos = calendarEventService.getAllCategories();
		} catch (MHVException e) {
			throw e;
		}
		boolean categoryExisted=false;
		if(categoryDtos != null){
			for(CategoryDTO catgDTO : categoryDtos){
				if(catgDTO.getCategory().equalsIgnoreCase(calendarCategoryDTO.getCategoryName())){
					categoryExisted=true;
					break;
				}
			}
		}
		
		if(categoryExisted){
			validationErrors.put("Event Category", "The calendar category name you entered already exists. Please try a different name.");
		}
	}

}
